#pragma GCC optimize("O3")
#pragma GCC target("avx2")
#include <cstdio>
#include <cassert>
#include <cstring>
#include <algorithm>
#include <utility>

const int N = 200000;
const int M = 2100;
int n;
bool d[M * 2], next[M * 2];
std::pair<int, int> ev[N];

bool test(int x) {
	memset(d, 0, sizeof d);
	d[M] = 1;
	for (int i = 0, j = 0; i <= 2000; ++i) {
		while (j < n && ev[j].first == i) {
			int l = std::max(-M, ev[j].second - x) + 1 + M;
			int r = std::min(M, ev[j].second + x) + M;
			for (int k = l; k < r; ++k) d[k] = 0;
			++j;
		}
		memset(next, 0, sizeof next);
		for (int k = 0; k < 2 * M; ++k) if (d[k]) next[k] = next[k - 1] = next[k + 1] = 1;
		memcpy(d, next, sizeof next);
	}
	for (int i = 0; i < 2 * M; ++i) if (d[i]) return 1;
	return 0;
}

int main() {
	scanf("%d", &n);
	for (int i = 0; i < n; ++i) {
		assert(ev[i].second >= -1000000000 && ev[i].second <= 1000000000);
		assert(ev[i].first <= 1000 && ev[i].first >= 0);
		scanf("%d%d", &ev[i].first, &ev[i].second);
		ev[i].first *= 2;
		ev[i].second *= 2;
	}
	std::sort(ev, ev + n);
	int l = 0, r = 2000000000;
	while (l < r) {
		int m = l + (r - l >> 1);
		if (test(m)) l = m + 1;
		else r = m;
	}
	--l;
	printf("%d", l / 2);
	if (l & 1) printf(".5");
	printf("\n");
	return 0;
}